/**
 * Project Dashboard JS
 */

function getJsonDashboardData(onlyName) {
  if (onlyName === undefined) onlyName = false;
  var data = dojo.byId('projectDashboardJsonData');
  if (onlyName) data = 'projectDashboardJsonData';
  return data;
}

function refreshDashboard() {
  var url = '../tool/jsonProjectDashboard.php';
  var jsonDiv = getJsonDashboardData(true);
  var callback = function() {
    drawProjectDashboard(false);
  }; 
  loadContent(url, jsonDiv, null, false, callback);
}

function saveLayoutRecording() {
  var layoutSelect = dijit.byId('layoutRecording');
  if (!layoutSelect) {
    showAlert(i18n('pleaseSelectLayout'));
    return;
  }
  var selectedLayout = layoutSelect.get('value');
  if (!selectedLayout) {
    showAlert(i18n('pleaseSelectLayout'));
    return;
  }
  var parametersToSave = [
    'datesStartDashboard',
    'datesEndDashboard',
    'statusDashboard',
	'priorityDashboard',
    'nextMilestoneDashboard',
    'weatherDashboard',
    'timelineDashboard',
    'workProgressDashboard',
    'budgetProgressDashboard',
    'risksProgressDashboard',
    'closedProjectDashboard',
    'pausedProjectsDashboard',
    'notStartedProjects',
    'colorMilestone'
  ];
  var paramValues = {};
  parametersToSave.forEach(function(paramName) {
    var widget = dijit.byId(paramName);
    if (widget) {
      paramValues[paramName] = widget.get('value');
    }
  });
  var listShowMilestoneWidget = dijit.byId('listShowMilestone');
  if (listShowMilestoneWidget) {
    paramValues['listShowMilestone'] = listShowMilestoneWidget.get('value');
  }
  var orderByWidget = dijit.byId('dashboardOrderBy');
  if (orderByWidget) {
    paramValues['dashboardOrderBy'] = orderByWidget.get('value');
    if (orderByWidget.get('value') === 'priority') {
      var prioritySwitch = dijit.byId('priorityDashboard');
      if (prioritySwitch && prioritySwitch.get('value') !== 'on') {
        prioritySwitch.set('value', 'on');
        enhancedSwitchHandler('priorityDashboard', 'on', false);
      }
      paramValues['priorityDashboard'] = 'on';
    }
  }
  var paramString = JSON.stringify(paramValues);
  var sessionKey = 'paramLayout_' + selectedLayout;
  saveDataToSession(sessionKey, paramString, true);
  showAlert(i18n('layoutSavedSuccessfully'));
}

function restoreLayoutRecording(layoutName) {
  if (!layoutName || layoutName === '' || layoutName === ' ') {
    return;
  }
  var sessionKey = 'paramLayout_' + layoutName;
  dojo.xhrGet({
    url: "../tool/getParamDashboard.php?key=" + sessionKey + addTokenIndexToUrl(),
    handleAs: "text",
    load: function(data, args) {
      try {
        if (!data || data === '' || data === 'null') {
          showAlert(i18n('noParamSaved'));
          return;
        }
        var params = JSON.parse(data);
        for (var paramName in params) {
          if (params.hasOwnProperty(paramName)) {
            var value = params[paramName];
            var widget = dijit.byId(paramName);
            if (widget) {
              widget.set('value', value);
			  if (paramName === 'dashboardOrderBy') {
			    saveDataToSession('dashboardOrderBy', value, true);           
			    if (value === 'priority') {
			      enhancedSwitchHandler('priorityDashboard', true, true);
			    }
			  } else {
			    saveDataToSession(paramName, value, true);
			    if (paramName !== 'listShowMilestone') {
			      var isVisible = (value === 'on');
			      applyParameterVisibility(paramName, isVisible);
			    }
			  }
            }
          }
        }
        // refreshDashboard(); 
      } catch (error) {
        console.error(error);
      }
    },
  });
}

function onSearchByLayoutChange(newLayout) {
  saveDataToSession('searchByLayout', newLayout, false);
  restoreLayoutRecording(newLayout);
}

function initializeLayoutRecording() {
  var addRecordingButton = dojo.byId('addRecordingDashboard');
  if (addRecordingButton) {
    dojo.connect(addRecordingButton, 'onclick', function(evt) {
      saveLayoutRecording();
    });
  }
  var searchByLayoutWidget = dijit.byId('searchByLayout');
  if (searchByLayoutWidget) {
    dojo.connect(searchByLayoutWidget, 'onChange', function(value) {
      onSearchByLayoutChange(value);
    });
  }
}

function getDashboardParameter(paramName) {
  var switchWidget = dijit.byId(paramName);
  if (switchWidget) {
    return switchWidget.get('value') === 'on';
  }
  return false;
}

function applyParameterVisibility(paramName, isVisible) {
  var displayValue = isVisible ? (paramName == 'nextMilestoneDashboard' || paramName == 'priorityDashboard' ? 'flex' : 'block') : 'none';
  needsChartResize = false;
  switch(paramName) {
    case 'datesStartDashboard':
      var startDateRows = document.querySelectorAll('.date-row.date-start');
      startDateRows.forEach(function(row) {
        row.style.display = displayValue;
      });
      break;
      
    case 'datesEndDashboard':
      var endDateRows = document.querySelectorAll('.date-row.date-end');
      endDateRows.forEach(function(row) {
        row.style.display = displayValue;
      });
      break;
      
    case 'statusDashboard':
      var statusElements = document.querySelectorAll('.project-status');
      statusElements.forEach(function(elem) {
        elem.style.display = displayValue;
      });
      break;
    
	case'priorityDashboard':
  	  var statusElements = document.querySelectorAll('.tile-priority');
	  statusElements.forEach(function(elem) {
	    elem.style.display = displayValue;
	  });
	break;
	
    case 'nextMilestoneDashboard':
      var milestoneElements = document.querySelectorAll('.tile-next-milestone');
      milestoneElements.forEach(function(elem) {
        elem.style.display = displayValue;
      });
      break;
      
    case 'weatherDashboard':
      var weatherElements = document.querySelectorAll('.tile-weather');
      weatherElements.forEach(function(elem) {
        elem.style.display = displayValue;
      });
      break;
      
    case 'resourcesDashboard':
      var resourcesElements = document.querySelectorAll('.tile-resources');
      resourcesElements.forEach(function(elem) {
        elem.style.display = displayValue;
      });
      break;
      
    case 'timelineDashboard':
      var timelineElements = document.querySelectorAll('.tile-timeline');
      timelineElements.forEach(function(elem) {
        elem.style.display = displayValue;
      });
      break;
	  
	case 'colorMilestone':
	  drawProjectDashboard(false);
	  break;
      
    case 'workProgressDashboard':
      var progressElements = document.querySelectorAll('.tile-work-progress');
      progressElements.forEach(function(elem) {
        elem.style.display = displayValue;
      });
	  needsChartResize = true;
      break;
      
    case 'budgetProgressDashboard':
      var budgetElements = document.querySelectorAll('.tile-budget-progress');
      budgetElements.forEach(function(elem) {
        elem.style.display = displayValue;
      });
	  needsChartResize = true;
      break;
      
    case 'risksProgressDashboard':
      var risksElements = document.querySelectorAll('.tile-risks-progress');
      risksElements.forEach(function(elem) {
        elem.style.display = displayValue;
      });
	  needsChartResize = true;
      break;
	  
	case 'closedProjectDashboard':
	case 'pausedProjectsDashboard':
	case 'notStartedProjects':
	  var allTiles = document.querySelectorAll('.project-tile');
	  var vItemList = dbd.getProjectList();
	  var showClosed = getDashboardParameter('closedProjectDashboard');
	  var showPaused = getDashboardParameter('pausedProjectsDashboard');
	  var showNotStarted = getDashboardParameter('notStartedProjects');
	  allTiles.forEach(function(tile) {
	    var projectId = tile.getAttribute('data-project-id');
	    var project = vItemList.find(function(p) { return p.getId() == projectId; });
	    if (project) {
		  var isIdle = (project.getIdle() == 1 || project.getIdle() == '1' || project.getIdle() === true);
		  var isPaused = (project.getPaused() == 1 || project.getPaused() == '1' || project.getPaused() === true);
		  var isNotStarted = (project.getHandled() == 0 || project.getHandled() == '0' || project.getHandled() === false);

	      var shouldHide = false;
          if (isIdle && !showClosed) shouldHide = true;
	      if (isPaused && !showPaused) shouldHide = true;
	      if (isNotStarted && !showNotStarted) shouldHide = true;
	      tile.style.display = shouldHide ? 'none' : 'block';
	    }
	  });
	  break;
	  
  }
  if (needsChartResize) {
    var allTiles = document.querySelectorAll('.project-tile');
    allTiles.forEach(function(tile) {
      adjustChartSizes(tile);
      redrawChartsForTile(tile);
    });
  }
}

function handleDatesMutualExclusivity(changedParam, newValue) {
  if (changedParam === 'datesStartDashboard') {
    if (newValue === 'on') {
      var datesEndSwitch = dijit.byId('datesEndDashboard');
      if (datesEndSwitch && datesEndSwitch.get('value') === 'on') {
        datesEndSwitch.set('value', 'off');
        saveDataToSession('datesEndDashboard', 'off', true);
        applyParameterVisibility('datesEndDashboard', false);
      }
    }
  } else if (changedParam === 'datesEndDashboard') {
    if (newValue === 'on') {
      var datesStartSwitch = dijit.byId('datesStartDashboard');
      if (datesStartSwitch && datesStartSwitch.get('value') === 'on') {
        datesStartSwitch.set('value', 'off');
        saveDataToSession('datesStartDashboard', 'off', true);
        applyParameterVisibility('datesStartDashboard', false);
      }
    }
  }
}

function enhancedSwitchHandler(paramName, newValue, completeRefresh) {
  if (completeRefresh === undefined) completeRefresh = false;
  var isVisible = (newValue === 'on');
  handleDatesMutualExclusivity(paramName, newValue);
  saveDataToSession(paramName, newValue, true); 
  if (completeRefresh) {
    refreshDashboard();
  } else {
    applyParameterVisibility(paramName, isVisible);
  }
}

function toggleDashboardParameter(paramName) {
  var switchWidget = dijit.byId(paramName);
  if (switchWidget) {
    var currentValue = switchWidget.get('value');
    var newValue = (currentValue === 'on') ? 'off' : 'on';
    switchWidget.set('value', newValue);
  }
}

function filterDashboard() {
  applyCurrentFilters();  
}

function applyCurrentFilters() {
  var idResponsible = dijit.byId('searchByResponsible').get('value');
  var idClient = dijit.byId('searchByClient').get('value');
  var idOrganization = dijit.byId('searchByOrganization').get('value');

  idResponsible = idResponsible ? idResponsible.toString().trim() : '';
  idClient = idClient ? idClient.toString().trim() : '';
  idOrganization = idOrganization ? idOrganization.toString().trim() : '';

  var vItemList = dbd.getProjectList();
  for (var j = 0; j < vItemList.length; j++) {
    var itemNode = dojo.byId(vItemList[j].getID());
    var itemResp = vItemList[j].getIdManager();
	var itemClient = vItemList[j].getIdClient();
	var itemOrganization = vItemList[j].getIdOrganization();

	var okResp = (!idResponsible) || (itemResp == idResponsible);
	var okClient = (!idClient) || (itemClient == idClient);
    var okOrganization = (!idOrganization) || (itemOrganization == idOrganization);

    if (okResp && okClient && okOrganization) {
      dojo.removeClass(itemNode, 'projectItemHide');
    } else {
      dojo.addClass(itemNode, 'projectItemHide');
    }
  }   
}

function getMilestoneFilter() {
  var widget = dijit.byId('listShowMilestone');
  if (widget) {
    var value = widget.get('value');
    return value && value !== ' ' ? value : null;
  }
  return null;
}

// Milestone idMilestoneType
function filterMilestonesByType(milestones, filterType) {
  if (!milestones || milestones.length === 0) return [];
  if (!filterType || filterType === ' ' || filterType === '') return [];
  if (filterType === 'all') return milestones;
  var filtered = milestones.filter(function(milestone) {
    var match = milestone.idtype && milestone.idtype.toString() === filterType.toString();
    return match;
  });
  return filtered;
}

function getNextMilestoneFiltered(milestones, filterType) {
  if (!milestones || milestones.length === 0) {
    return null;
  }
  var filteredMilestones = filterMilestonesByType(milestones, filterType);
  for (var i = 0; i < filteredMilestones.length; i++) {
    if (filteredMilestones[i].done === 0 || filteredMilestones[i].done === '0') {
      return filteredMilestones[i];
    }
  }
  return null;
}

// Next milestone by idMilestoneType not done
function getMilestoneFilter() {
  var widget = dijit.byId('listShowMilestone');
  if (widget) {
    var value = widget.get('value');
    if (!value || value === ' ' || value === '') {
      return null;
    }
    return value;
  }
  return null;
}

function onMilestoneFilterChange(newValue) {
  saveDataToSession('listShowMilestone', newValue, true);
  drawProjectDashboard(false);
}


function darkenColor(hex, percent) {
  hex = hex.replace('#','');
  let r = parseInt(hex.substring(0,2), 16);
  let g = parseInt(hex.substring(2,4), 16);
  let b = parseInt(hex.substring(4,6), 16);

  r = Math.floor(r * (100 - percent) / 100);
  g = Math.floor(g * (100 - percent) / 100);
  b = Math.floor(b * (100 - percent) / 100);

  return "#" + r.toString(16).padStart(2,'0')
             + g.toString(16).padStart(2,'0')
             + b.toString(16).padStart(2,'0');
}

function initMilestoneFilterListener() {
  var milestoneFilterWidget = dijit.byId('listShowMilestone');
  if (milestoneFilterWidget) {
    if (milestoneFilterWidget._milestoneChangeHandle) {
      dojo.disconnect(milestoneFilterWidget._milestoneChangeHandle);
    }
    milestoneFilterWidget._milestoneChangeHandle = dojo.connect(milestoneFilterWidget, 'onChange', function(value) {
      onMilestoneFilterChange(value);
    });
  }
}

function onMilestoneFilterChange(newValue) {
  saveDataToSession('listShowMilestone', newValue, true);
  setTimeout(function() {
    drawProjectDashboard(false);
  }, 100);
}
var JSDashboard; 
if (!JSDashboard) JSDashboard = {};

// ==================== OBJET DASHBOARD ====================
JSDashboard.Dashboard = function() {
  var vProjectList = new Array();
  
  this.AddProject = function(value) {
    vProjectList.push(value);
  };
  
  this.getProjectList = function() { 
    return vProjectList; 
  };
  
  this.clearProjects = function() {
    vProjectList = [];
  };
  
  // Draw dashboard
  this.Draw = function() {
    window.top.showWait();
    
    var container = dojo.byId('divProjectDashboardContent');
    if (!container) {
      console.error('Container divProjectDashboardContent not found');
      window.top.hideWait();
      return;
    }
	dijit.registry.findWidgets(container).forEach(function(widget) {
	   try {
	     widget.destroyRecursive();
	   } catch(e) {
	     console.warn('Error destroying widget:', e);
	   }
	 });
    container.innerHTML = '';
    if (vProjectList.length === 0) {
      container.innerHTML = '<div style="text-align:center;padding:50px;color:#666;">'+i18n('noDataFound')+'</div>';
      window.top.hideWait();
      return;
    }
	
	var orderByWidget = dijit.byId('dashboardOrderBy');
	if (orderByWidget) {
	  var orderBy = orderByWidget.get('value');
	  if (orderBy) {
	    vProjectList.sort(function(a, b) {
	      switch(orderBy) {
	        case 'wbs':
	          return (a.getWbs() || '').localeCompare(b.getWbs() || '');
	        case 'name':
	          return (a.getName() || '').localeCompare(b.getName() || '');
	        case 'work':
	          var workA = parseFloat(a.getWorkPlanned()) || parseFloat(a.getWorkValidated()) || null;
	          var workB = parseFloat(b.getWorkPlanned()) || parseFloat(b.getWorkValidated()) || null;
	          if (workA === null && workB === null) return 0;
	          if (workA === null) return 1;
	          if (workB === null) return -1;
	          return workB - workA;
	        case 'priority':
	          return (parseInt(a.getPriority()) || 9999) - (parseInt(b.getPriority()) || 9999);
	        case 'EndDate':
	          var dateA = a.getRealEndDate() || a.getPlannedEndDate() || a.getValidatedEndDate() || '';
	          var dateB = b.getRealEndDate() || b.getPlannedEndDate() || b.getValidatedEndDate() || '';
	          return dateA.localeCompare(dateB);
	        default:
	          return 0;
	      }
	    });
	  }
	}
  
    var tilesHtml = '<div class="dashboard-tiles-container">';  
    // Create each tile
    for (var i = 0; i < vProjectList.length; i++) {
      var project = vProjectList[i];
      tilesHtml += project.drawTile();
    }
    tilesHtml += '</div>';
    container.innerHTML = tilesHtml;
	dojo.parser.parse(container);
	
	for (var i = 0; i < vProjectList.length; i++) {
	  var project = vProjectList[i];
	  var tileElement = container.querySelector('.project-tile[data-project-id="' + project.getId() + '"]');
	  if (!tileElement) continue;
	  var timelineId = "timeline-" + project.getId();
	  var timelineCanvas = document.getElementById(timelineId);
	  if (timelineCanvas) {
		let elementProject = document.getElementById("project_" + project.getId());
		let valueProject = elementProject.getAttribute("data-typeMilestone");
		var filteredMilestones = filterMilestonesByType(project.getMilestones(), valueProject);
		var useColorMilestone = getDashboardParameter('colorMilestone');
	    createTimeline(timelineId,project.getValidatedStartDate(),project.getPlannedStartDate(), project.getValidatedEndDate(),project.getPlannedEndDate(),filteredMilestones,useColorMilestone);
	  }
	  if (tileElement.chartResizeObserver) {
	    tileElement.chartResizeObserver.disconnect();
	  }

	  tileElement.chartResizeObserver = new ResizeObserver(() => {
	    adjustChartSizes(tileElement);
	    redrawChartsForTile(tileElement);
	  });
	  tileElement.chartResizeObserver.observe(tileElement);
	  	  
	  // Weather tooltip
	  var weatherElement = document.getElementById('weather-' + project.getId());
	  if (weatherElement) {
	    setupTooltipDashboard(weatherElement, function() {
		  var label = this.getAttribute('data-weather-name');
		  var labelBis = label.charAt(0).toUpperCase() + label.slice(1);
	      return labelBis;
	    }.bind(weatherElement));
	  }
	  
	  // Date tooltips - Start dates
	  for (var j = 0; j < 3; j++) {
	    var startDateElement = document.getElementById('startDate_' + project.getId() + '_' + j);
	    if (startDateElement) {
	      setupTooltipDashboard(startDateElement, function() {
	        var label = this.getAttribute('data-date-label');
			var labelBis = label.charAt(0).toUpperCase() + label.slice(1);
	        var value = this.getAttribute('data-date-value');
	        return labelBis + ' : ' + value;
	      }.bind(startDateElement));
	    }
	  }
	    
	  // Date tooltips - End dates
	  for (var j = 0; j < 3; j++) {
	    var endDateElement = document.getElementById('endDate_' + project.getId() + '_' + j);
	    if (endDateElement) {
	      setupTooltipDashboard(endDateElement, function() {
	        var label = this.getAttribute('data-date-label');
			var labelBis = label.charAt(0).toUpperCase() + label.slice(1);
	        var value = this.getAttribute('data-date-value');
	        return  labelBis + ' : ' + value;
	      }.bind(endDateElement));
	    }
	  }
		
	  // Milestone tooltip
	  var milestoneElement = document.getElementById('milestone-' + project.getId());
	  if (milestoneElement) {
		setupTooltipDashboard(milestoneElement, function() {
		  var label = this.getAttribute('data-milestone-label');
		  var date = this.getAttribute('data-milestone-date');
		  var name = this.getAttribute('data-milestone-name');
		  return { toString: function() { return label + ' : ' + date + '<br>' + name; } };
		}.bind(milestoneElement));
	  }
	  
	  // Priority tooltip
	  var milestoneElement = document.getElementById('priority-' + project.getId());
	  if (milestoneElement) {
	  setupTooltipDashboard(milestoneElement, function() {
	    var label = this.getAttribute('data-priority-label');
	    var value = this.getAttribute('data-priority-value');
	    return label + ' : ' +  value;
	  }.bind(milestoneElement));
	  }
	  
	  // No manager defined
	  var managerNameElement = document.getElementById('managerName' + project.getId());
	  if (managerNameElement) {
	    var isUndefined = managerNameElement.getAttribute('data-manager-undefined') === 'true';
	    if (isUndefined) {
	      setupTooltipDashboard(managerNameElement, function() {
	        return i18n('Responsible') + ' : ' + i18n('undefinedValue');
	      });
	    }
	  }
	  
	}
	
	document.querySelectorAll('.tile-menu-container').forEach(container => {
	  const btn = container.querySelector('.tile-menu-btn');
	  const dropdown = container.querySelector('.tile-menu-dropdown');
	  
	  container.addEventListener('mouseenter', () => {
	    dropdown.style.opacity = '1';
	    dropdown.style.visibility = 'visible';
	    dropdown.style.transform = 'translateY(0)';
	  });
	  
	  container.addEventListener('mouseleave', () => {
	    dropdown.style.opacity = '0';
	    dropdown.style.visibility = 'hidden';
	    dropdown.style.transform = 'translateY(-10px)';
	  });
	  
	  container.addEventListener('click', (e) => {
	    e.stopPropagation();
	  });
	});
	
	setTimeout(function() {
	  for (var i = 0; i < vProjectList.length; i++) {
	    var project = vProjectList[i];
	    var tileElement = container.querySelector('.project-tile[data-project-id="' + project.getId() + '"]');
	    if (!tileElement) continue;
	    
	    adjustChartSizes(tileElement);
	    
	    var workProgressId = "workProgress-" + project.getId();
	    var workProgressCanvas = document.getElementById(workProgressId);
	    if (workProgressCanvas) {
	      progressChart(workProgressCanvas, project.getWorkValidated(), project.getWorkReal(), project.getWorkLeft(), project.getWorkPlanned(), 'workProgressCanvas', '<div class="iconImputation16 imageColorNewGui iconImputation iconSize16"></div>');
	    }
	    
	    var budgetProgressId = "budgetProgress-" + project.getId();
	    var budgetProgressCanvas = document.getElementById(budgetProgressId);
	    if (budgetProgressCanvas) {
	      progressChart(budgetProgressCanvas, project.getTotalValidatedCost(), project.getTotalRealCost(), project.getTotalLeftCost(), project.getTotalPlannedCost(), 'budgetProgressCanvas', '<div class="iconExpenses16 imageColorNewGui iconExpenses iconSize16"></div>');
	    }
	    
	    var risksProgressId = "risksProgress-" + project.getId();
	    var risksProgressCanvas = document.getElementById(risksProgressId);
	    if (risksProgressCanvas) {
	      progressChartRisk(risksProgressCanvas, project.getClosedRisk(), project.getDoneRisk(), project.getTodoRisk(), project.getTotalRisk(), '<div class="iconCriticality16 imageColorNewGui iconCriticality iconSize16"></div>');
	    }
	  }
	}, 0);
	
	applyCurrentFilters();

    window.top.hideWait();
  };
};

// ==================== OBJET PROJECT ====================
JSDashboard.Project = function(pProject) {
  var vId = pProject.id;
  var vName = pProject.name;
  var vColor = pProject.color || '#999999';
  var vWbs = pProject.wbs;
  var vPriority = pProject.priority;
  var vPaused = pProject.paused;
  var vIdle = pProject.idle;
  var vHandled = pProject.handled;
  var vFile = pProject.photo;
  var vIdPhoto = pProject.idphoto;

  //dates
  var vValidatedStartDate = pProject.validatedstartdate;
  var vPlannedStartDate = pProject.plannedstartdate;
  var vRealStartDate = pProject.realstartdate;
  var vValidatedEndDate = pProject.validatedenddate;
  var vPlannedEndDate = pProject.plannedenddate;
  var vRealEndDate = pProject.realenddate;
  
  var vWorkValidated = pProject.validatedwork;
  var vWorkReal = pProject.realwork;
  var vWorkPlanned = pProject.plannedwork;
  var vWorkLeft = pProject.leftwork;
  
  var vTotalValidatedCost = pProject.totalvalidatedcost;
  var vTotalRealCost = pProject.totalrealcost;
  var vTotalPlannedCost = pProject.totalplannedcost;
  var vTotalLeftCost = pProject.totalleftcost;
  
  var vRisk = pProject.risk;
  var vClosedRisk = vRisk.closed;
  var vTodoRisk = vRisk.todo;
  var vDoneRisk = vRisk.done;
  var vTotalRisk = vRisk.total;
  
  var vNextMilestone = pProject.nextmilestone;
  var vMilestones = pProject.milestones;
  var vStatus = pProject.status;
  var vManager = pProject.manager;
  var vIdManger = vManager.id;
  var vWeather = pProject.weather;
  var vIdClient = pProject.idclient;
  var vIdOrganization = pProject.idorganization;
  
  this.getId = function() { return vId; };
  this.getID = function() { return "project_"+vId; };  
  this.getName = function() { return vName; };
  this.getColor = function() { return vColor; };
  this.getPriority = function() { return vPriority; };
  this.getPaused = function() { return vPaused; };
  this.getIdle = function() { return vIdle; };
  this.getWbs = function() { return vWbs; };
  this.getHandled = function() { return vHandled; };
  
  this.getValidatedStartDate = function() { return vValidatedStartDate; };
  this.getPlannedStartDate = function() { return vPlannedStartDate; };
  this.getRealStartDate = function() { return vRealStartDate; };
  this.getValidatedEndDate = function() { return vValidatedEndDate; };
  this.getPlannedEndDate = function() { return vPlannedEndDate; };
  this.getRealEndDate = function() { return vRealEndDate; };
    
  this.getNextMilestone = function() { return vNextMilestone; };
  this.getMilestones = function() { return vMilestones; };
  
  this.getStatus = function() { return vStatus; };
  this.getStatusColor = function() { return vStatusColor; };
  this.getWorkValidated = function() {return vWorkValidated;};
  this.getWorkReal = function() {return vWorkReal;};
  this.getWorkPlanned = function() {return vWorkPlanned;};
  this.getWorkLeft = function() {return vWorkLeft;};
  
  // Color Date
  var vColorValidatedStart = pProject.colorvalidatedstart;
  var vColorPlannedStart = pProject.colorplannedstart;
  var vColorRealStart = pProject.colorrealstart;
  var vColorValidatedEnd = pProject.colorvalidatedend;
  var vColorPlannedEnd = pProject.colorplannedend;
  var vColorRealEnd = pProject.colorrealend;
  
  this.getTotalValidatedCost = function() { return vTotalValidatedCost;};
  this.getTotalRealCost = function() { return vTotalRealCost;};
  this.getTotalPlannedCost = function() { return vTotalPlannedCost;};
  this.getTotalLeftCost = function() { return vTotalLeftCost;};
  
  this.getClosedRisk = function() { return vClosedRisk;};
  this.getTodoRisk = function() { return vTodoRisk;};
  this.getDoneRisk = function() { return vDoneRisk;};
  this.getTotalRisk = function() { return vTotalRisk;};
  
  this.getIdManager = function() {return vIdManger;};
  this.getIdClient = function() {return vIdClient;};
  this.getIdOrganization = function() {return vIdOrganization;};
  
  // Draw a tile
  this.drawTile = function() {
	var showDatesStart = getDashboardParameter('datesStartDashboard');
	var showDatesEnd = getDashboardParameter('datesEndDashboard');
	var showStatus = getDashboardParameter('statusDashboard');
	var showPriority = getDashboardParameter('priorityDashboard');
	var showNextMilestone = getDashboardParameter('nextMilestoneDashboard');
	var showWeather = getDashboardParameter('weatherDashboard');
	var showResources = getDashboardParameter('resourcesDashboard'); // v.2
	var showTimeline = getDashboardParameter('timelineDashboard');
	var colorMilestone = getDashboardParameter('colorMilestone');
	var listShowMilestone = getMilestoneFilter();
	var showWorkProgress = getDashboardParameter('workProgressDashboard');
	var showBudgetProgress = getDashboardParameter('budgetProgressDashboard');
	var showRisksProgress = getDashboardParameter('risksProgressDashboard');
	var showClosedProject = getDashboardParameter('closedProjectDashboard');
	var showPausedProject = getDashboardParameter('pausedProjectsDashboard');
	var showNotStartedProjects = getDashboardParameter('notStartedProjects');
    var html = '';
    
	var globalDisplay = ((!showClosedProject && vIdle) || (!showPausedProject && vPaused) || (!showNotStartedProjects && !vHandled)) ? 'none' : 'block';
	
    html += '<div class="project-tile" data-project-id="' + vId + '" data-project-color="' + vColor + '" data-typeMilestone ="'+listShowMilestone+'" id="project_'+vId+'" style="display:' + globalDisplay + ';">';
    
    // ========== UPPER PART: DATES ==========
	var backgroundStyle = '';
	if (vFile) backgroundStyle = 'url(&quot;' + vFile + '&quot;) center/cover no-repeat';
	else backgroundStyle = vColor ? 'linear-gradient(135deg, ' + vColor + ' 0%, #e9ecef 100%)' : 'linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%)';

	html += '<div class="tile-dates-section" onclick="if(event.target === this) {top.gotoElement(\'Project\',' + vId + ');}" style="cursor:pointer;background: ' + backgroundStyle + ';">';
	
	// Button menu
	html += '<div class="tile-menu-container" style="position:absolute;top:8px;right:8px;z-index:1000;">';
	html += '  <button class="tile-menu-btn" style="background:rgba(255,255,255,0.3);border-radius:6px;padding:6px;border:none;cursor:pointer;transition:all 0.2s;" onmouseover="this.style.background=\'rgba(255,255,255,0.4)\'" onmouseout="this.style.background=\'rgba(255,255,255,0.2)\'">';
	html += '      <div class="iconOptions16 iconOptions iconSize16 imageColorNewGui"></div>';
	html += '  </button>';
	html += '  <div class="tile-menu-dropdown" style="position:absolute;top:36px;right:0;background:white;opacity:0;visibility:hidden;transform:translateY(-10px);transition:all 0.2s;overflow:hidden;">';

	// Goto Project
	html += '    <button class="menu-item" title="'+i18n('kanbanGotoItem',new Array(vId, vId))+'" onclick="event.stopPropagation();top.gotoElement(\'Project\','+vId+')" onmouseover="this.style.background=\'#f8f9fa\'" onmouseout="this.style.background=\'white\'">';
	html += '      <div class="iconGoto16 iconGoto iconSize16 imageColorNewGui"></div>';
	html += '    </button>';

	// Search Planning
	html += '    <button class="menu-item" title="'+i18n('buttonSearch')+'" onclick="event.stopPropagation();top.directSelectProject(\'Project\','+vId+',false,true);" onmouseover="this.style.background=\'#f8f9fa\'" onmouseout="this.style.background=\'white\'">';
	html += '      <div class="iconButtonSearchPlanning16 iconButtonSearchPlanning iconSize16 imageColorNewGui"></div>';
	html += '    </button>';

	// Goto WorkPlan
	html += '    <button class="menu-item" title="'+i18n('gotoWorkPlan')+'" onclick="event.stopPropagation();setSelectedProject(\''+vId+'\',\''+htmlEncode(vName)+'\',\'selectedProject\');gotoElement(\'WorkPlan\',null,false,null,\'workPlan\')" onmouseover="this.style.background=\'#f8f9fa\'" onmouseout="this.style.background=\'white\'">';
	html += '      <div class="iconPlannedWorkManual iconSize16 imageColorNewGui"></div>';
	html += '    </button>';

	// Goto Risk
	html += '    <button class="menu-item" title="'+i18n('gotoRisks')+'" onclick="event.stopPropagation();setSelectedProject(\''+vId+'\',\''+htmlEncode(vName)+'\',\'selectedProject\');gotoElement(\'Risk\',null,false)" onmouseover="this.style.background=\'#f8f9fa\'" onmouseout="this.style.background=\'white\'">';
	html += '      <div class="iconCriticality16 imageColorNewGui iconCriticality iconSize16"></div>';
	html += '    </button>';

	html += '  </div>';
	html += '</div>';
	
	if (vFile){
	  html += '<div id="addAttachementProjectPic" title="'+i18n('removeAttachementProjectPic')+'" onclick="event.stopPropagation(); removeAttachmentWithConfirm(this, '+vIdPhoto+', '+vId+');" style="position:absolute;top:50%;left:50%;transform:translate(-50%, -50%);transition:all 0.3s;background:rgba(255,255,255,0.9);border-radius:50%;padding:12px;box-shadow:0 2px 8px rgba(0,0,0,0.15);cursor:pointer;" onmouseover="this.style.background=\'white\';this.style.boxShadow=\'0 4px 12px rgba(0,0,0,0.25)\'" onmouseout="this.style.background=\'rgba(255,255,255,0.9)\';this.style.boxShadow=\'0 2px 8px rgba(0,0,0,0.15)\'">'; 
	  html += '  <div class="iconRemove16 imageColorNewGui iconRemove iconSize16"></div></div>';
	}else {
      html += '<div id="addAttachementProjectPic" title="'+i18n('addAttachementProjectPic')+'" onclick="event.stopPropagation(); addAttachmentWithUpdate(this,\'Project\','+vId+',\'profilePic\');" style="position:absolute;top:50%;left:50%;transform:translate(-50%, -50%);transition:all 0.3s;background:rgba(255,255,255,0.9);border-radius:50%;padding:12px;box-shadow:0 2px 8px rgba(0,0,0,0.15);cursor:pointer;" onmouseover="this.style.background=\'white\';this.style.boxShadow=\'0 4px 12px rgba(0,0,0,0.25)\'" onmouseout="this.style.background=\'rgba(255,255,255,0.9)\';this.style.boxShadow=\'0 2px 8px rgba(0,0,0,0.15)\'">';
	  html += '  <div class="iconAdd16 imageColorNewGui iconAdd iconSize16"></div></div>';
	}

	
	var startDisplay = showDatesStart ? 'block' : 'none';
	var endDisplay = showDatesEnd ? 'block' : 'none';

	// Start Dates
		var startDates = [
		  { value: vValidatedStartDate, label: i18n('colValidatedStartDate'), color: vColorValidatedStart },
		  { value: vPlannedStartDate,   label: i18n('colPlannedStartDate'),   color: vColorPlannedStart },
		  { value: vRealStartDate,      label: i18n('colRealStartDate'),      color: vColorRealStart }
		];
		startDates.forEach(function(dateInfo, index) {
		  var isEmpty = !dateInfo.value || dateInfo.value === '—';
		  var dateId = 'startDate_' + vId + '_' + index;
		  var displayValue = isEmpty ? i18n('undefinedValue') : dateInfo.value;
		  var displayValueBis = isEmpty ? '-' : dateInfo.value;

		  var backgroundColor = '';
		  var textColor = '';

		  if (!isEmpty && dateInfo.color) {
		    if (dateInfo.color.indexOf('gradient') !== -1) {
		      backgroundColor = 'background:' + dateInfo.color + ';';
		    } else {
		      backgroundColor = 'background-color:' + dateInfo.color + ';';
		    }
		    textColor = 'color:' + getForeColor(dateInfo.color) + ';';
		  }

		  html += '<div class="date-row date-start' + (isEmpty ? ' no-date' : '') + '" ';
		  html += 'id="' + dateId + '" ';
		  html += 'data-date-label="' + htmlEncode(dateInfo.label) + '" ';
		  html += 'data-date-value="' + htmlEncode(displayValue) + '" ';
		  html += 'style="display:' + startDisplay + ';' + backgroundColor + textColor + '">';
		  html += displayValueBis;
		  html += '</div>';
		});

		// End Dates
		var endDates = [
		  { value: vValidatedEndDate, label: i18n('colValidatedEndDate'), color: vColorValidatedEnd },
		  { value: vPlannedEndDate,   label: i18n('colPlannedEndDate'),   color: vColorPlannedEnd },
		  { value: vRealEndDate,      label: i18n('colRealEndDate'),      color: vColorRealEnd }
		];
		endDates.forEach(function(dateInfo, index) {
		  var isEmpty = !dateInfo.value || dateInfo.value === '—';
		  var dateId = 'endDate_' + vId + '_' + index;
		  var displayValue = isEmpty ? i18n('undefinedValue') : dateInfo.value;
		  var displayValueBis = isEmpty ? '-' : dateInfo.value;

		  var backgroundColor = '';
		  var textColor = '';

		  if (!isEmpty && dateInfo.color) {
		    if (dateInfo.color.indexOf('gradient') !== -1) {
		      backgroundColor = 'background:' + dateInfo.color + ';';
		    } else {
		      backgroundColor = 'background-color:' + dateInfo.color + ';';
		    }
		    textColor = 'color:' + getForeColor(dateInfo.color) + ';';
		  }

		  html += '<div class="date-row date-end' + (isEmpty ? ' no-date' : '') + '" ';
		  html += 'id="' + dateId + '" ';
		  html += 'data-date-label="' + htmlEncode(dateInfo.label) + '" ';
		  html += 'data-date-value="' + htmlEncode(displayValue) + '" ';
		  html += 'style="display:' + endDisplay + ';' + backgroundColor + textColor + '">';
		  html += displayValueBis;
		  html += '</div>';
		});

	html += '</div>';
    
    // ========== MAIN PART ==========
    html += '<div class="tile-main">';
    
	html += '<div style="display:flex; flex-direction: row-reverse; gap:10px; position:absolute; top:-12px; right:10px; z-index:10;">';
	// Status
	var statusDisplay = showStatus ? 'flex' : 'none';
	if (vStatus.name) {
	  html += '<div class="project-status" style="display:' + statusDisplay + ';background-color: ' + vStatus.color + ';color:'+getForeColor(vStatus.color)+'">';
	  html += vStatus.name;
	  html += '</div>';
	}

	var priorityDisplay = showPriority ? 'flex' : 'none';
	if (vPriority) {
	  html += '<div class="tile-priority" style="display:' + priorityDisplay + ';gap:4px;background:#E8E8E8;color:var(--color-dark);"';
	  html += 'id="priority-' + vId + '" ';
	  html += 'data-priority-value="' + htmlEncode(vPriority) + '" ';
	  html += 'data-priority-label="' + htmlEncode(i18n('Priority')) + '" >';
	  html += '<div class="iconPriority16 iconPriority iconSize16 imageColorNewGuiNoSelection"></div>';
	  html += '<span>' + htmlEncode(vPriority) + '</span>';
	  html += '</div>';
	}
	html += '</div>';
    
	html += '<div class="tile-header" style="display:flex;align-items:center;justify-content:space-between;	min-height: 36px;">';

	// Left part :square + name
	html += '<div class="tile-header-left" style="display:flex;align-items:center;gap:6px;cursor: pointer;" onclick="top.gotoElement(\'Project\','+vId+');">';
	html += '  <div class="project-color-square" style="background-color:' + vColor + '"></div>';
	html += '  <h3 class="project-title" style="font-size:14px;font-weight:600;">' + vName + '</h3>';
	html += '</div>';

	// Right part : milestone + weather
	html += '<div class="tile-header-right" style="display:flex;position: relative;align-items:center;gap:10px;left:-3px;">';

	// Next Milestone
	var milestoneDisplay = showNextMilestone ? 'flex' : 'none';
	if (vNextMilestone) {
	  var nextMilestoneData = getNextMilestoneFiltered(vMilestones, listShowMilestone);  
	  if (nextMilestoneData) {
		var milestone = nextMilestoneData.date;
		var milestoneName = nextMilestoneData.name;
		
		let useCustomColor = false;
		let customColor = '#ffa64d';	  
		if (colorMilestone && nextMilestoneData.color) {
		  useCustomColor = true;
		  customColor = nextMilestoneData.color;
		}	  
		let validationColor = '#44af69';
		let hasValidated = nextMilestoneData.validateddate !== null && nextMilestoneData.validateddate !== undefined;
		let hasPlanned = nextMilestoneData.planneddate !== null && nextMilestoneData.planneddate !== undefined;
		if (hasValidated && hasPlanned && nextMilestoneData.plannedDateParsed > nextMilestoneData.validatedDateParsed) validationColor = '#f8333c';	  
		const milestoneColor = useCustomColor ? customColor : validationColor;
		 
		var darkerMilestoneColor = darkenColor(milestoneColor, 20);
		var parts = milestone.split('/');
		var day = parts[0]?.padStart(2, '0') || '--';
		var month = parts[1]?.padStart(2, '0') || '--';
		html += '<div class="tile-next-milestone" ';
		html += 'id="milestone-' + vId + '" ';
		html += 'data-milestone-name="' + htmlEncode(milestoneName) + '" ';
		html += 'data-milestone-date="' + htmlEncode(milestone) + '" ';
		html += 'data-milestone-label="' + htmlEncode(i18n('nextMilestoneDashboard')) + '" ';
		html += 'style="display:' + milestoneDisplay + '; background-color:' + milestoneColor + ';border: 2px solid'+darkerMilestoneColor+';color:'+getForeColor(milestoneColor)+'">';
		html += '  <div style="line-height:1;">' + day + '</div>';
		html += '  <div style="line-height:1;">' + month + '</div>';
		html += '</div>';
	  }
	}

	// Weather 
	var weatherDisplay = showWeather ? 'block' : 'none';
	if (vWeather.icon) {
	    var displayHeightWidht = 'width:30px; height:30px';
	    if (vWeather.icon.startsWith('skill_')) displayHeightWidht='width:78px; height:22px';
	    weatherHtml = '<td class="todayData" style="width:50px;vertical-align:middle;width:22px;"><img style="'+displayHeightWidht+'" src="icons/' + vWeather.icon + '"/></td>';
	    var positionLeft = 'position:relative;left:'+ (vWeather.icon.startsWith('skill_') ? '-15px' : '8px') + ';'
	} else {
	    weatherHtml = '<td class="todayData" style="width:50px;"><div class="colorHealth" style="margin-left:5px;width:22px; height:22px;border-radius:12px;background:' + vWeather.color + ';">&nbsp;</div></td>';
	    var positionLeft = ''
	}
	html += '<div class="tile-weather" id="weather-' + vId + '" data-weather-name="' + vWeather.name + '" style="display:' + weatherDisplay + ';width:24px;height:24px;' + positionLeft + '">';
	html += '  <td class="icon-weather" style="font-size:20px;opacity:0.6;">' + weatherHtml + '</td>';
	html += '</div>';

	html += '</div>'; // End tile-header-right
	html += '</div>'; // End tile-header
	
	// Manager
	html += '<div class="tile-manager">';
	var hasManager = vManager && vManager.name;
	if (hasManager){
	  if (vManager.isfile) {
		html += '<img id="responsible' + vId + '" valueuser="' + htmlDecode(vManager.name) + '" ';
		html += 'style="border-radius:5px;float:left;height:20px;width:20px;top:1px;" ';
		html += 'src="' + htmlDecode(vManager.file) + '" ';
		html += 'onmouseenter="showToolTip(\'tooltipUserThumb_' + vId + '\');" ';
		html += 'onmouseleave="hideToolTip(\'tooltipUserThumb_' + vId + '\', 200);" />';
	  } else {
		var arrayColors = ['#1abc9c', '#2ecc71', '#3498db', '#9b59b6', '#34495e','#16a085', '#27ae60', '#2980b9', '#8e44ad', '#2c3e50','#f1c40f', '#e67e22', '#99CC00', '#e74c3c', '#95a5a6','#d35400', '#c0392b', '#bdc3c7', '#7f8c8d'];
		var keyColor = vManager.id % arrayColors.length;
		var bgColor = (keyColor in arrayColors) ? arrayColors[keyColor] : arrayColors[0];
		html += '<span style="color:#ffffff;background-color:' + bgColor + ';float:left;font-size:15px;border-radius:5px;font-weight:300;text-shadow:none;text-align:center;height:20px;width:20px;top:1px;" ';
		html += 'onmouseenter="showToolTip(\'tooltipUserThumb_' + vId + '\');" ';
		html += 'onmouseleave="hideToolTip(\'tooltipUserThumb_' + vId + '\', 200);" ';
		html += 'id="responsible' + vId + '" valueuser="' + htmlDecode(vManager.name) + '">' + htmlDecode(vManager.file) + '</span>';
	  }
	  html += '<span class="manager-name" style="font-size:13px;color:#333; position:relative; top:2px;" ';
	  html += 'onmouseenter="showToolTip(\'tooltipUserThumb_' + vId + '\');" ';
	  html += 'onmouseleave="hideToolTip(\'tooltipUserThumb_' + vId + '\', 200);">';
	  html += htmlDecode(vManager.namemanager) + '</span>';
	  // Tooltip manager
	  html += '<div class="comboButtonInvisible" dojoType="dijit.form.DropDownButton" id="tooltipUserThumb_' + vId + '" ';
	  html += 'name="tooltipUserThumb_' + vId + '" style="position:absolute;top:' + (20 * 0.75) + 'px;left:-' + (20 * 0.25) + 'px;height:0px;overflow:hidden;">';
	  html += '  <div dojoType="dijit.TooltipDialog" id="dialogTooltipUserThumb_' + vId + '" style="cursor:pointer;" ';
	  html += 'onMouseEnter="clearTimeout(hideToolTipTimeout);" onMouseLeave="hideToolTip(\'tooltipUserThumb_' + vId + '\',200);" >';
	  html += '    <table style="width:100%"><tr>';
	  html += '      <td style="padding-right:5px;">';
	  html += (vManager.isfile) ? '<img style="border:1px solid #AAA;width:32px;height:32px;float:left;" src="' + htmlDecode(vManager.file) + '"/>' : '';
	  html += '      </td>';
	  html += '      <td style="min-width:100px;max-width:200px;">' + htmlDecode(vManager.name) + '</td>';
	  html += '    </tr></table>';
	  html += '  </div>';
	  html += '</div>';
	} else {
	  // No manager - display placeholder
	  html += '<span id="responsible' + vId + '" ';
	  html += 'data-manager-undefined="true" ';
	  html += 'style="color:#cccccc;float:left;font-size:15px;border-radius:5px;font-weight:300;text-align:center;height:20px;width:20px;top:1px;cursor:pointer;" ';
	  html += '>-</span>';
	  html += '<span class="manager-name" id="managerName' + vId + '" ';
	  html += 'data-manager-undefined="true" ';
	  html += 'style="font-size:13px;color:#cccccc;cursor:pointer;">';
	  html += i18n('undefinedValue') + '</span>';	
	}
	
	html += '</div>';
		
	// Timeline
	var timelineDisplay = showTimeline ? 'block' : 'none';
	html += '<div class="tile-timeline" style="display:' + timelineDisplay + ';">';
	html += '<canvas id="timeline-' + vId + '"></canvas>';
	html += '</div>';
	
	
	// =================== Progress charts ===================
	html += `<div class="tile-progress-charts">`;
	var fullRight ='';
	var fullLeft = '';
	if (dojo.byId('hideStreamNewGui') && dojo.byId('hideStreamNewGui').style.display === "none" && showWorkProgress && showBudgetProgress &&  showRisksProgress){
		fullRight = 'right:-10px;';
		fullLeft = 'left:-10px;';
	}
	var progressDisplay = showWorkProgress ? 'block' : 'none';
	html += '<div class="tile-work-progress" style="display:' + progressDisplay + ';'+fullRight+'">';
	html += '<canvas id="workProgress-' + vId + '"></canvas>';
	html += '</div>';
	
	// Budget progress
	var budgetProgressDisplay = showBudgetProgress ? 'block' : 'none';
	html += '<div class="tile-budget-progress" style="display:' + budgetProgressDisplay + ';">';
	html += '<canvas id="budgetProgress-' + vId + '"></canvas>';
	html += '</div>';
	
	//tile-risks-progress
	var risksProgressDisplay = showRisksProgress ? 'block' : 'none';
	html += '<div class="tile-risks-progress" style="display:' + risksProgressDisplay + ';'+fullLeft+'">';
	html += '<canvas id="risksProgress-' + vId + '"></canvas>';
	html += '</div>';
	
	html += '</div>'; //End progress charts
	
    html += '</div>'; // end tile-main
    
	
	// ============= BOTTOM PART: SHORTCUTS =============
    html += '</div>'; // end project-tile
    
    return html;
  };
};

// ==================== MAIN FUNCTION : DRAW DASHBOARD ====================
function drawProjectDashboard(onlyRefresh) {
  if (onlyRefresh === undefined) onlyRefresh = false;
  
  // Create obj Dashboard
  if (!onlyRefresh) {
    window.dbd = new JSDashboard.Dashboard();
  }
  
  // JSON
  var jsonData = getJsonDashboardData();
  
  // Check data
  if (!jsonData || jsonData.innerHTML.indexOf('{"identifier"') < 0) {
    if (jsonData) {
      showAlert(jsonData.innerHTML);
    } else {
      showAlert('Erreur: données JSON introuvables');
    }
    hideWait();
    return;
  }
  // Parse the JSON
  try {
    var store = eval('(' + jsonData.innerHTML + ')');
  } catch(e) {
    console.error('ERROR Parsing jsonData in drawProjectDashboard()');
    console.error(jsonData.innerHTML);
    hideWait();
    return;
  }
  var projects = store.items;
  dbd.clearProjects();
  // Create obj Project
  for (var i = 0; i < projects.length; i++) {
    var projectData = projects[i];
    var newProject = new JSDashboard.Project(projectData);
    dbd.AddProject(newProject);
  }
  dbd.Draw();
  initMilestoneFilterListener();
}

// ==================== TIMELINE FUNCTION ====================
function createTimeline(canvasId,validatedStartDate,actualStartDate,validatedEndDate,plannedEndDate, milestones,useColor) {
  const canvas = document.getElementById(canvasId);
  if (!canvas) return;

  const ctx = canvas.getContext("2d");
  let interactiveElements = [];
  
  function drawTimeline() {
    const projectTile = canvas.closest('.project-tile');
    const width = projectTile ? projectTile.clientWidth - 30 : 350;
    const height = 80;

    canvas.width = width;
    canvas.height = height;

    const shapeOffset = 10;
    const leftMargin = 20 - shapeOffset;
    const rightMargin = 20 - shapeOffset;
    const usableWidth = width - leftMargin - rightMargin;

    const lineY = height - 30;

    const validatedY = lineY - 5;
    const actualY = lineY + 5;

    ctx.clearRect(0, 0, width, height);

    // Parse dates
	const validatedStart = parseDate(validatedStartDate);
	const actualStart = parseDate(actualStartDate);
	const validatedEnd = parseDate(validatedEndDate);
	const plannedEnd = parseDate(plannedEndDate);

	const parsedMilestones = milestones
	  .map(m => {
	    const validated = parseDate(m.validateddate);
	    const planned = parseDate(m.plannedenddate);
	    const real = parseDate(m.realenddate);
	    
	    return { 
	      ...m, 
	      validatedDateParsed: validated,
	      plannedDateParsed: planned,
	      realDateParsed: real
	    };
	  })
	  .filter(m => m.validatedDateParsed || m.plannedDateParsed || m.realDateParsed);

	const today = new Date();
	today.setHours(0, 0, 0, 0);
	const allDates = [
	  validatedStart,
	  actualStart,
	  validatedEnd,
	  plannedEnd,
	  today,
	  ...parsedMilestones.map(m => m.validatedDateParsed).filter(Boolean),
	  ...parsedMilestones.map(m => m.plannedDateParsed).filter(Boolean),
	  ...parsedMilestones.map(m => m.realDateParsed).filter(Boolean)
	].filter(Boolean);

    const minDate = new Date(Math.min(...allDates));
    const maxDate = new Date(Math.max(...allDates));
    const totalDuration = maxDate - minDate;

    function dateToX(date) {
      return leftMargin + ((date - minDate) / totalDuration) * usableWidth;
    }

    const todayX = dateToX(today);

    // Reset interactive elements
    interactiveElements = [];

    const startX = leftMargin - shapeOffset;
    const endX = width - rightMargin + shapeOffset;

    ctx.beginPath();
    ctx.moveTo(startX, lineY);
    ctx.lineTo(todayX, lineY);
    ctx.strokeStyle = "green";
    ctx.lineWidth = 3;
    ctx.stroke();

    ctx.beginPath();
    ctx.moveTo(todayX, lineY);
    ctx.lineTo(endX, lineY);
    ctx.strokeStyle = "#999";
    ctx.lineWidth = 2;
    ctx.stroke();

    ctx.beginPath();
    ctx.moveTo(todayX, validatedY - 14);
    ctx.lineTo(todayX, actualY + 14);
    ctx.strokeStyle = "orange";
    ctx.lineWidth = 2;
    ctx.stroke();

    const todayText = i18n('today');
    ctx.font = "9px Arial";
    ctx.textAlign = "center";
    const textWidth = ctx.measureText(todayText).width;
    const textX = Math.max(textWidth / 2 + 5, Math.min(todayX, width - textWidth / 2 - 5)); 

    ctx.fillStyle = "orange";
    ctx.fillText(todayText, textX, validatedY - 20);

    function drawMarker(ctx, x, y, direction, color, label, dateStr) {
      const lineLength = 18;
      const radius = 5;

      let circleY, lineStartY, lineEndY;

      if (direction === "up") {
        lineStartY = lineY;
        lineEndY = lineY - lineLength;
        circleY = lineEndY;
      } else {
        lineStartY = lineY;
        lineEndY = lineY + lineLength;
        circleY = lineEndY;
      }

      ctx.beginPath();
      ctx.moveTo(x, lineStartY);
      ctx.lineTo(x, lineEndY);
      ctx.strokeStyle = color;
      ctx.lineWidth = 2;
      ctx.stroke();

      ctx.beginPath();
      ctx.arc(x, circleY, radius, 0, Math.PI * 2);
      ctx.fillStyle = color;
      ctx.fill();

      interactiveElements.push({
        x: x,
        y: circleY,
        radius: radius + 3, 
        label: label,
        date: dateStr,
		type:'marker',
      });
    }

    function drawTriangle(ctx, x, y, orientation, color, milestone) {
      const size = 5;
      const isFilled = milestone.done == 1 || milestone.done == '1';

      ctx.beginPath();
      if (orientation === "up") {
        ctx.moveTo(x, lineY - 6 - size);
        ctx.lineTo(x - size, lineY - 6 + size);
        ctx.lineTo(x + size, lineY - 6 + size);
      } else {
        ctx.moveTo(x, lineY + 6 + size);
        ctx.lineTo(x - size, lineY + 6 - size);
        ctx.lineTo(x + size, lineY + 6 - size);
      }
      ctx.closePath();
	  if (isFilled) {
	    ctx.fillStyle = color;
	    ctx.fill();
	  } else {
		ctx.fillStyle = '#ffffff';
		ctx.fill();
	    ctx.strokeStyle = color;
	    ctx.lineWidth = 2;
	    ctx.stroke();
	  }	

      const centerY = orientation === "up" ? lineY - 6 : lineY + 6;
      interactiveElements.push({
        x: x,
        y: centerY,
        radius: size + 3,
        label: milestone.name,
        date: milestone.dateOriginal, 
		id: milestone.id, 
        type: 'milestone',
		dateType: milestone.dateType,
		onClick: () => {
		}
      });
    }
	
	function getValidationColor(validatedDate, plannedDate) {
	  const validated = parseDate(validatedDate);
	  const planned = parseDate(plannedDate);
	  if (!validated && planned) return '#44af69';
	  if (validated && planned && planned > validated) return '#f8333c'; // red
	  return '#44af69'; //green
	}
	
	const startColor = getValidationColor(validatedStartDate, actualStartDate);
	const endColor = getValidationColor(validatedEndDate, plannedEndDate);
    if (validatedStart)
      drawMarker(ctx, dateToX(validatedStart), validatedY, "up", startColor, i18n('colValidatedStart'), validatedStartDate);

    if (actualStart)
      drawMarker(ctx, dateToX(actualStart), actualY, "down", startColor, i18n('colPlannedStart'), actualStartDate);

    if (validatedEnd)
      drawMarker(ctx, dateToX(validatedEnd), validatedY, "up", endColor, i18n('colValidatedEnd'), validatedEndDate);

    if (plannedEnd)
      drawMarker(ctx, dateToX(plannedEnd), actualY, "down", endColor, i18n('colPlannedEnd'), plannedEndDate);

	parsedMilestones.forEach(m => {
	  let useCustomColor = false;
	  let customColor = '#ffa64d';
	  
	  if (useColor && m.color) {
	    useCustomColor = true;
	    customColor = m.color;
	  }
	  
	  let validationColor = '#44af69';
	  let hasValidated = m.validatedDateParsed !== null && m.validatedDateParsed !== undefined;
	  let hasPlanned = m.plannedDateParsed !== null && m.plannedDateParsed !== undefined;
	  let hasReal = m.realDateParsed !== null && m.realDateParsed !== undefined;
	  
	  //red
	  if (hasValidated && hasPlanned && m.plannedDateParsed > m.validatedDateParsed) {
	    validationColor = '#f8333c';
	  }
	  
	  const finalColor = useCustomColor ? customColor : validationColor;
	  
	  if (hasValidated) {
	    const xValidated = dateToX(m.validatedDateParsed);
	    drawTriangle(ctx, xValidated, lineY, "up", finalColor, { 
	      ...m, 
	      date: m.validatedDateParsed, 
	      dateOriginal: m.validateddate,
		  dateType: i18n('colValidated') 
	    });
	  }
	  
	  if (hasReal) {
	    const xReal = dateToX(m.realDateParsed);
	    drawTriangle(ctx, xReal, lineY, "down", finalColor, { 
	      ...m, 
	      date: m.realDateParsed, 
	      dateOriginal: m.realenddate,
	      dateType: i18n('colReal')
	    });
	  } else if (hasPlanned) {
	    const xPlanned = dateToX(m.plannedDateParsed);
	    drawTriangle(ctx, xPlanned, lineY, "down", finalColor, { 
	      ...m, 
	      date: m.plannedDateParsed, 
	      dateOriginal: m.plannedenddate,
	      dateType: i18n('colPlanned')
	    });
	  }
	});
  }
  
  // Setup tooltip
  let tooltipDiv = document.getElementById(canvasId + '-tooltip');
  if (!tooltipDiv) {
    tooltipDiv = document.createElement('div');
    tooltipDiv.id = canvasId + '-tooltip';
    tooltipDiv.style.position = 'absolute';
    tooltipDiv.style.background = 'rgba(0, 0, 0, 0.8)';
    tooltipDiv.style.color = 'white';
    tooltipDiv.style.padding = '6px 10px';
    tooltipDiv.style.borderRadius = '4px';
    tooltipDiv.style.fontSize = '12px';
    tooltipDiv.style.pointerEvents = 'none';
    tooltipDiv.style.display = 'none';
    tooltipDiv.style.zIndex = '1000';
    tooltipDiv.style.whiteSpace = 'nowrap';
    document.body.appendChild(tooltipDiv);
  }

  // Event listeners
  canvas.addEventListener('mousemove', function(event) {
    const rect = canvas.getBoundingClientRect();
    const mouseX = event.clientX - rect.left;
    const mouseY = event.clientY - rect.top;

    let found = false;

    for (let elem of interactiveElements) {
      const distance = Math.sqrt(Math.pow(mouseX - elem.x, 2) + Math.pow(mouseY - elem.y, 2));
      
      if (distance <= elem.radius) {
        let tooltipContent;
        if (elem.type == 'milestone' && elem.dateType) {
          tooltipContent = `<strong>${elem.label}</strong><br>${elem.dateType} : ${elem.date}`;
        } else {
          tooltipContent = `<strong>${elem.label}</strong><br>${elem.date}`;
        }

        tooltipDiv.innerHTML = tooltipContent;
        tooltipDiv.style.display = 'block';

        tooltipDiv.style.left = '-9999px';
        tooltipDiv.style.top = '-9999px';
        
        const tooltipRect = tooltipDiv.getBoundingClientRect();
        const tooltipWidth = tooltipRect.width;
        const tooltipHeight = tooltipRect.height;
        
        const viewportWidth = window.innerWidth;
        const viewportHeight = window.innerHeight;

        let left = event.clientX + 10;
        let top = event.clientY - 30;
        if (left + tooltipWidth > viewportWidth) left = event.clientX - tooltipWidth - 10;
        if (left < 0) left = 10;
        if (top < 0) top = event.clientY + 20;
        if (top + tooltipHeight > viewportHeight) top = viewportHeight - tooltipHeight - 10;
        tooltipDiv.style.left = left + 'px';
        tooltipDiv.style.top = top + 'px';
        canvas.style.cursor = 'pointer';
        found = true;
        break;
      }
    }
    
    if (!found) {
      tooltipDiv.style.display = 'none';
      canvas.style.cursor = 'default';
    }
  });
  
  canvas.addEventListener('click', function(event) {
    const rect = canvas.getBoundingClientRect();
    const mouseX = event.clientX - rect.left;
    const mouseY = event.clientY - rect.top;
	tooltipDiv.style.display = 'none';
    for (let elem of interactiveElements) {
      const distance = Math.sqrt(
        (mouseX - elem.x) * (mouseX - elem.x) +
        (mouseY - elem.y) * (mouseY - elem.y)
      );

      if (distance <= elem.radius) {
        if (elem.type=='milestone') directSelectProject('Milestone',elem.id,false,true);
        return; 
      }
    }
  });

  canvas.addEventListener('mouseleave', function() {
    tooltipDiv.style.display = 'none';
    canvas.style.cursor = 'default';
  });
  
  setTimeout(drawTimeline, 0);
  
  if (canvas.resizeObserver) {
    canvas.resizeObserver.disconnect();
  }
  
  const projectTile = canvas.closest('.project-tile');
  if (projectTile) {
    canvas.resizeObserver = new ResizeObserver(() => {
      drawTimeline();
    });
    canvas.resizeObserver.observe(projectTile);
  }
}

// Helper function to parse dates from DD/MM/YYYY or YYYY-MM-DD format
function parseDate(dateStr) {
  if (!dateStr || dateStr === 'null' || dateStr === null) return null;
  
  let date = null;
  
  // Format DD/MM/YYYY
  if (dateStr.includes('/')) {
    const parts = dateStr.split('/');
    if (parts.length === 3) {
      date = new Date(parts[2], parts[1] - 1, parts[0]);
    }
  }
  
  // Format YYYY-MM-DD
  if (dateStr.includes('-')) {
    const parts = dateStr.split('-');
    if (parts.length === 3) {
      date = new Date(parts[0], parts[1] - 1, parts[2]);
    }
  }

  if (date) {
    date.setHours(0, 0, 0, 0);
  }
  
  return date;
}

		

// ==================== PROGRESS CHART FUNCTIONs ====================
function progressChart(canvas, validated, real, left, planned, chartType, icon) {
  if (!canvas) return;
  const ctx = canvas.getContext('2d');
  const size = canvas.width;
  const centerX = size / 2;
  const centerY = size / 2;
  const outerRadius = size / 3;
  const innerRadius = size * 0.25;
  const strokeWidth = size / 15;

  const realColor = '#656565';
  const validatedColor = '#2b9eb3';
  const lightGrayColor = '#e8e8e8';

  if ((!validated || validated <= 0) && (!left || left <= 0)) {
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    ctx.beginPath();
    ctx.arc(centerX, centerY, innerRadius, 0, 2 * Math.PI, false);
    ctx.lineWidth = strokeWidth;
    ctx.strokeStyle = lightGrayColor;
    ctx.stroke();

    ctx.fillStyle = '#cccccc';
    ctx.font = 'bold 24px Arial';
    ctx.textAlign = 'center';
    ctx.textBaseline = 'middle';
    ctx.fillText('—', centerX, centerY);

    if (planned !== undefined && planned !== null) {
      ctx.fillStyle = '#666666';
      ctx.font = '12px Arial';
      ctx.textAlign = 'center';
      ctx.textBaseline = 'top';
	  var plannedFormated = planned;
	  if (chartType=='workProgressCanvas'){
	    var paramUnit=window.top.paramWorkUnit;
	    if (paramUnit == 'hours') unit =`${i18n('shortHour')}`;
	    else unit =`${i18n('shortDay')}`;
		plannedFormated = workFormatter(planned,null,false,true);
	  } else if (chartType=='budgetProgressCanvas') {
	    unit = window.top.paramCurrency;
		plannedFormated = costFormatter(planned,null,false,true);
	  }
	  if (typeof plannedFormated === 'string' && plannedFormated.includes('<')) {
	      var tempDiv = document.createElement('div');
	      tempDiv.innerHTML = plannedFormated;
	      plannedFormated = tempDiv.textContent || tempDiv.innerText || plannedFormated;
	    }
	  ctx.fillText(i18n('colReassessed').charAt(0).toUpperCase() + i18n('colReassessed').slice(1)+' : ' + plannedFormated , centerX, size - 11);
    }

    canvas.chartData = {
      noData: true,
      chartType: chartType
    };
    setupTooltipNoData(canvas, chartType);
    return;
  }

  const baseValue = (validated && validated > 0) ? validated : (real + left);
  const remainingColor = (!validated || validated <= 0) ? '#44af69' : ((real + left > validated) ? '#f8333c' : '#44af69');
  
  // Angle calculation
  const realAngle = (real / baseValue) * Math.PI;
  const leftAngle = (left === 0 || !left) ? Math.PI : (left / baseValue) * Math.PI;
  const progress = Math.round((real / baseValue) * 100);

  // Clear canvas
  ctx.clearRect(0, 0, canvas.width, canvas.height);

  // Grey lower section : outer
  ctx.beginPath();
  ctx.arc(centerX, centerY, outerRadius, 0, Math.PI, false);
  ctx.lineWidth = strokeWidth;
  ctx.strokeStyle = lightGrayColor;
  ctx.stroke();

  // Outer arc : validated
  ctx.beginPath();
  ctx.arc(centerX, centerY, outerRadius, Math.PI, 2 * Math.PI, false);
  ctx.lineWidth = strokeWidth;
  ctx.strokeStyle = (validated && validated > 0) ? validatedColor : '#e8e8e8' ;
  ctx.stroke();

  // Grey lower section : inner
  ctx.beginPath();
  ctx.arc(centerX, centerY, innerRadius, 0, 2 * Math.PI, false);
  ctx.lineWidth = strokeWidth;
  ctx.strokeStyle = lightGrayColor;
  ctx.stroke();

  // Inner arc : real
  ctx.beginPath();
  ctx.arc(centerX, centerY, innerRadius, Math.PI, Math.PI + realAngle, false);
  ctx.lineWidth = strokeWidth;
  ctx.strokeStyle = realColor;
  ctx.stroke();

  // Inner arc : left 
  const leftColor = (left === 0 || !left || !validated || validated <= 0) ? '#44af69' : remainingColor;
  ctx.beginPath();
  ctx.arc(centerX, centerY, innerRadius, Math.PI + realAngle, Math.PI + realAngle + leftAngle, false);
  ctx.lineWidth = strokeWidth;
  ctx.strokeStyle = leftColor;
  ctx.stroke();

  // Percentage text in the centre
  if (icon) {
    ctx.fillStyle = '#2c3e50';
    ctx.font = 'bold 16px Arial';
    ctx.textAlign = 'center';
    ctx.textBaseline = 'middle';
    ctx.fillText(progress + '%', centerX, centerY + 13);
    let iconContainer = canvas.parentElement.querySelector('.chart-icon-container');
    if (!iconContainer) {
      iconContainer = document.createElement('div');
      iconContainer.className = 'chart-icon-container';
      iconContainer.style.cssText = 'position: absolute; top: 45%; left: 50%; transform: translate(-50%, -60%); pointer-events: none;';
      canvas.parentElement.style.position = 'relative';
      canvas.parentElement.appendChild(iconContainer);
    }
    iconContainer.innerHTML = icon;
  } else {
    ctx.fillStyle = '#2c3e50';
    ctx.font = 'bold 20px Arial';
    ctx.textAlign = 'center';
    ctx.textBaseline = 'middle';
    ctx.fillText(progress + '%', centerX, centerY + 3);
  }

  // Planned
  if (planned !== undefined && planned !== null) {
    ctx.fillStyle = '#666666';
    ctx.font = '12px Arial';
    ctx.textAlign = 'center';
    ctx.textBaseline = 'top';
	var plannedFormated = planned;
	if (chartType=='workProgressCanvas'){
	  var paramUnit=window.top.paramWorkUnit;
	  if (paramUnit == 'hours') unit =`${i18n('shortHour')}`;
	  else unit =`${i18n('shortDay')}`;
	  plannedFormated = workFormatter(planned,null,false,true);
	} else if (chartType=='budgetProgressCanvas') {
	  unit = window.top.paramCurrency;
	  plannedFormated = costFormatter(planned,null,false,true);
	}
	if (typeof plannedFormated === 'string' && plannedFormated.includes('<')) {
	    
	    var tempDiv = document.createElement('div');
	    tempDiv.innerHTML = plannedFormated;
	    plannedFormated = tempDiv.textContent || tempDiv.innerText || plannedFormated;
	  }
    ctx.fillText(i18n('colReassessed').charAt(0).toUpperCase() + i18n('colReassessed').slice(1)+' : ' + plannedFormated , centerX, size - 11);
  }

  // Storing information for tooltips
  canvas.chartData = {
    centerX, centerY, outerRadius, innerRadius, strokeWidth,
    realAngle, leftAngle, validated, real, left, textRadius: 25, progress,
    noData: false
  };
  setupTooltip(canvas, chartType);
}

function setupTooltip(canvas,chartType) {
  var globalCurrencyPosition=window.top.paramCurrencyPosition;
  var paramUnit=window.top.paramWorkUnit;
  // Check if tooltip already exists
  if (canvas.tooltipSetup) return;
  
  // Create tooltip element if it doesn't exist
  let tooltip = document.getElementById('tooltip_projectDash');
  if (!tooltip) {
    tooltip = document.createElement('div');
    tooltip.id = 'tooltip_projectDash';
    tooltip.style.cssText = `
      position: fixed;
      background-color: rgba(0, 0, 0, 0.8);
      color: white;
      padding: 8px 12px;
      border-radius: 4px;
      font-size: 14px;
      pointer-events: none;
      z-index: 10000;
      opacity: 0;
      transition: opacity 0.2s;
	  white-space: nowrap;
    `;
    document.body.appendChild(tooltip);
  }
  
  function positionTooltip(e, tooltipText) {
    if (!tooltipText) {
      tooltip.style.opacity = '0';
      return;
    }
    tooltip.innerHTML  = tooltipText;
    tooltip.style.opacity = '1';
    // Get tooltip dimensions (need to make it visible first to measure)
    tooltip.style.left = '-9999px';
    tooltip.style.top = '-9999px';
    tooltip.style.opacity = '1';
    const tooltipRect = tooltip.getBoundingClientRect();
    const tooltipWidth = tooltipRect.width;
    const tooltipHeight = tooltipRect.height; 
    // Get viewport dimensions
    const viewportWidth = window.innerWidth;
    const viewportHeight = window.innerHeight;
    // Default position (right and above cursor)
    let left = e.clientX + 10;
    let top = e.clientY - 30;
    // Check if tooltip goes beyond right / left / top /bottom edge
    if (left + tooltipWidth > viewportWidth) left = e.clientX - tooltipWidth - 10; 
    if (left < 0)  left = 10;
    if (top < 0) top = e.clientY + 20; 
    if (top + tooltipHeight > viewportHeight) top = viewportHeight - tooltipHeight - 10; 
       
    tooltip.style.left = left + 'px';
    tooltip.style.top = top + 'px';
  }
  
  // Mouse move handler
  canvas.addEventListener('mousemove', (e) => {
    const rect = canvas.getBoundingClientRect();
    const x = e.clientX - rect.left;
    const y = e.clientY - rect.top;  
    if (!canvas.chartData) return;
    const { centerX, centerY, outerRadius, innerRadius, strokeWidth, realAngle, leftAngle, validated, real, left, textRadius, progress} = canvas.chartData;
    let tooltipText = '';
	var unit ='';
	var textProgress = `${i18n('progress')}`;
    if (chartType=='workProgressCanvas'){
      if (paramUnit == 'hours') unit =`${i18n('shortHour')}`;
	  else unit =`${i18n('shortDay')}`;
	  textProgress = `${i18n('sectionWork')}`;
	} else if (chartType=='budgetProgressCanvas') {
	  unit = window.top.paramCurrency;
	  textProgress = `${i18n('Budget')}`;
	} else if (chartType=='technicalProgressCanvas') {
      textProgress = `${i18n('menuTechnicalProgress')}`;
  	}
	// Check if the mouse is near the center text
	const distanceToCenter = Math.sqrt(Math.pow(x - centerX, 2) + Math.pow(y - centerY, 2));
	if (distanceToCenter < textRadius)  tooltipText = textProgress + ` : ${progress}%`;
	
	const formatValueWithUnit = (value) => {
	  var formattedValue;
	  if (chartType === 'budgetProgressCanvas') {
	    formattedValue = costFormatter(value);
	  } else if (chartType == 'workProgressCanvas') {
	    formattedValue = workFormatter(value);
	  } else if (chartType == 'technicalProgressCanvas') {
	    if (value == 1) return `${(value)}` + ' ' + `${i18n('unit')}`;
	    else return `${(value)}` + ' ' + `${i18n('units')}`;
	  }
	  if (typeof formattedValue === 'string' && formattedValue.includes('<')) {
	    var tempDiv = document.createElement('div');
	    tempDiv.innerHTML = formattedValue;
	    formattedValue = tempDiv.textContent || tempDiv.innerText || formattedValue;
	  }  
	  return formattedValue;
	};
	
	// Check validated arc
	if (isPointOnArc(x, y, centerX, centerY, outerRadius, Math.PI, 2 * Math.PI, strokeWidth)) {
	  tooltipText = `${i18n('colValidated').charAt(0).toUpperCase() + i18n('colValidated').slice(1)} : ${formatValueWithUnit(validated)}`;
	}
	// Check real arc
	else if (isPointOnArc(x, y, centerX, centerY, innerRadius, Math.PI, Math.PI + realAngle, strokeWidth)) {
	  tooltipText = `${i18n('colReal').charAt(0).toUpperCase() + i18n('colReal').slice(1)} : ${formatValueWithUnit(real)}`;
	}
	// Check left arc
	else if (isPointOnArc(x, y, centerX, centerY, innerRadius, Math.PI + realAngle, Math.PI + realAngle + leftAngle, strokeWidth)) {
	  tooltipText = `${i18n('colLeft').charAt(0).toUpperCase() + i18n('colLeft').slice(1)} : ${formatValueWithUnit(left)}`;
	}
    
    positionTooltip(e, tooltipText);
  });
  
  // Mouse leave handler
  canvas.addEventListener('mouseleave', () => {
    tooltip.style.opacity = '0';
  });
  
  canvas.tooltipSetup = true;
}
      
// Function to check whether a point lies on an arc
function isPointOnArc(x, y, centerX, centerY, radius, startAngle, endAngle, strokeWidth) {
  const dx = x - centerX;
  const dy = y - centerY;
  const distance = Math.sqrt(dx * dx + dy * dy);
  const angle = Math.atan2(dy, dx);
            
  // Normalise the angle between -PI and PI
  let normalizedAngle = angle;
  if (normalizedAngle < startAngle - Math.PI) normalizedAngle += 2 * Math.PI;
  if (normalizedAngle > endAngle + Math.PI) normalizedAngle -= 2 * Math.PI;        
  const isInRadius = distance >= radius - strokeWidth / 2 && distance <= radius + strokeWidth / 2;
  const isInAngle = normalizedAngle >= startAngle && normalizedAngle <= endAngle;
            
  return isInRadius && isInAngle;
}

function progressChartRisk(canvas, closed, done, todo, total, icon) {
  if (!canvas) return;
  const ctx = canvas.getContext('2d');
  const size = canvas.width;
  const centerX = size / 2;
  const centerY = size / 2;
  const outerRadius = size / 3;
  const innerRadius = size * 0.25;
  const strokeWidth = size / 15;
            
  const closedColor = '#2c3e50';
  const doneColor = '#44af69';
  const todoColor = '#f8333c';
  const totalColor = '#2b9eb3';
  const lightGrayColor = '#e8e8e8';
  
  if (!total || total <= 0) {
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    ctx.beginPath();
    ctx.arc(centerX, centerY, innerRadius, 0, 2 * Math.PI, false);
    ctx.lineWidth = strokeWidth;
    ctx.strokeStyle = lightGrayColor;
    ctx.stroke();
    ctx.fillStyle = '#cccccc';
    ctx.font = 'bold 24px Arial';
    ctx.textAlign = 'center';
    ctx.textBaseline = 'middle';
    ctx.fillText('—', centerX, centerY);
	
	
	ctx.fillStyle = '#666666';
	ctx.font = '12px Arial';
	ctx.textAlign = 'center';
	ctx.textBaseline = 'top';
	ctx.fillText(i18n('colCountTotal').charAt(0).toUpperCase() + i18n('colCountTotal').slice(1)+' : ' + total + ' '+ i18n('Risk').charAt(0).toLowerCase() + i18n('Risk').slice(1) , centerX, size - 11);
	
	canvas.chartData = {
	  noData: true,
	  chartType: "risksProgressCanvas"
	};
	setupTooltipNoData(canvas, "risksProgressCanvas");

    return;
  }  
  // Angle calculation
  const closedAngle = (closed / total) * 2 * Math.PI;
  const doneAngle = (done / total) * 2 * Math.PI;
  const todoAngle = (todo / total) * 2 * Math.PI;
  const progress = Math.round((done / total) * 100);          
  // Clear canvas
  ctx.clearRect(0, 0, canvas.width, canvas.height);       
  // Outer arc : total (cercle complet)
  ctx.beginPath();
  ctx.arc(centerX, centerY, outerRadius, 0, 2 * Math.PI, false);
  ctx.lineWidth = strokeWidth;
  ctx.strokeStyle = totalColor;
  ctx.stroke();          
  // Inner arc : closed
  ctx.beginPath();
  ctx.arc(centerX, centerY, innerRadius, 0, closedAngle, false);
  ctx.lineWidth = strokeWidth;
  ctx.strokeStyle = closedColor;
  ctx.stroke();        
  // Inner arc : done 
  ctx.beginPath();
  ctx.arc(centerX, centerY, innerRadius, closedAngle, closedAngle + doneAngle, false);
  ctx.lineWidth = strokeWidth;
  ctx.strokeStyle = doneColor;
  ctx.stroke();          
  // Inner arc : todo
  ctx.beginPath();
  ctx.arc(centerX, centerY, innerRadius, closedAngle + doneAngle, closedAngle + doneAngle + todoAngle, false);
  ctx.lineWidth = strokeWidth;
  ctx.strokeStyle = todoColor;
  ctx.stroke();           
  // Percentage text in the centre  
  if (icon) {
    ctx.fillStyle = '#2c3e50';
    ctx.font = 'bold 16px Arial';
    ctx.textAlign = 'center';
    ctx.textBaseline = 'middle';
    ctx.fillText(progress + '%', centerX, centerY + 13);
    let iconContainer = canvas.parentElement.querySelector('.chart-icon-container');
    if (!iconContainer) {
      iconContainer = document.createElement('div');
      iconContainer.className = 'chart-icon-container';
      iconContainer.style.cssText = 'position: absolute; top: 45%; left: 50%; transform: translate(-50%, -60%); pointer-events: none;';
      canvas.parentElement.style.position = 'relative';
      canvas.parentElement.appendChild(iconContainer);
    }
    iconContainer.innerHTML = icon;
  } else {
    ctx.fillStyle = '#2c3e50';
    ctx.font = 'bold 20px Arial';
    ctx.textAlign = 'center';
    ctx.textBaseline = 'middle';
    ctx.fillText(progress + '%', centerX, centerY + 3);
  }   
  
  if (total) {
    ctx.fillStyle = '#666666';
    ctx.font = '12px Arial';
    ctx.textAlign = 'center';
    ctx.textBaseline = 'top';
	var textRisk =  total>1 ?i18n('menuRisk').charAt(0).toLowerCase() + i18n('menuRisk').slice(1) : i18n('Risk').charAt(0).toLowerCase() + i18n('Risk').slice(1);
    ctx.fillText(i18n('colCountTotal').charAt(0).toUpperCase() + i18n('colCountTotal').slice(1)+' : ' + total + ' '+ textRisk , centerX, size - 11);
  }
      
  // Storing information for tooltips
  canvas.chartData = {
    centerX, centerY, outerRadius, innerRadius, strokeWidth,
    closedAngle, doneAngle, todoAngle, total, closed, done, todo, textRadius: 25, progress
  };
  setupTooltipRisk(canvas);
}

function setupTooltipRisk(canvas) {
  // Check if tooltip already exists
  if (canvas.tooltipSetup) return;
  // Create tooltip element if it doesn't exist
  let tooltip = document.getElementById('tooltip_projectDash');
  if (!tooltip) {
    tooltip = document.createElement('div');
    tooltip.id = 'tooltip_projectDash';
    tooltip.style.cssText = `
      position: fixed;
      background-color: rgba(0, 0, 0, 0.8);
      color: white;
      padding: 8px 12px;
      border-radius: 4px;
      font-size: 14px;
      pointer-events: none;
      z-index: 10000;
      opacity: 0;
      transition: opacity 0.2s;
      white-space: nowrap;
    `;
    document.body.appendChild(tooltip);
  }
  
  function positionTooltip(e, tooltipText) {
    if (!tooltipText) {
      tooltip.style.opacity = '0';
      return;
    }
    tooltip.textContent = tooltipText;
    tooltip.style.opacity = '1';
    tooltip.style.left = '-9999px';
    tooltip.style.top = '-9999px';
    tooltip.style.opacity = '1';
    const tooltipRect = tooltip.getBoundingClientRect();
    const tooltipWidth = tooltipRect.width;
    const tooltipHeight = tooltipRect.height; 
    const viewportWidth = window.innerWidth;
    const viewportHeight = window.innerHeight;
    let left = e.clientX + 10;
    let top = e.clientY - 30;
    if (left + tooltipWidth > viewportWidth) left = e.clientX - tooltipWidth - 10; 
    if (left < 0) left = 10;
    if (top < 0) top = e.clientY + 20; 
    if (top + tooltipHeight > viewportHeight) top = viewportHeight - tooltipHeight - 10; 
    tooltip.style.left = left + 'px';
    tooltip.style.top = top + 'px';
  }
  
  // Mouse move handler
  canvas.addEventListener('mousemove', (e) => {
    const rect = canvas.getBoundingClientRect();
    const x = e.clientX - rect.left;
    const y = e.clientY - rect.top;  
    if (!canvas.chartData) return;
    const { centerX, centerY, outerRadius, innerRadius, strokeWidth, closedAngle, doneAngle, todoAngle, total, closed, done, todo, textRadius, progress} = canvas.chartData;
    let tooltipText = '';
    // Check if the mouse is near the center text
    const distanceToCenter = Math.sqrt(Math.pow(x - centerX, 2) + Math.pow(y - centerY, 2));
    if (distanceToCenter < textRadius) {
      tooltipText = `${i18n('menuRiskManagement').charAt(0).toUpperCase() + i18n('menuRiskManagement').slice(1)} : ${progress}%`;
    }
    // Check total arc (outer)
    else if (isPointOnArcRisk(x, y, centerX, centerY, outerRadius, 0, 2 * Math.PI, strokeWidth)) {
      tooltipText = `${i18n('colCountTotal').charAt(0).toUpperCase() + i18n('colCountTotal').slice(1)} : ${total}`;
    }
    // Check closed arc
    else if (isPointOnArcRisk(x, y, centerX, centerY, innerRadius, 0, closedAngle, strokeWidth)) {
      tooltipText = `${i18n('idle').charAt(0).toUpperCase() + i18n('idle').slice(1)} : ${closed}`;
    }
    // Check done arc
    else if (isPointOnArcRisk(x, y, centerX, centerY, innerRadius, closedAngle, closedAngle + doneAngle, strokeWidth)) {
      tooltipText = `${i18n('colDone').charAt(0).toUpperCase() + i18n('colDone').slice(1)} : ${done}`;
    }
    // Check todo arc
    else if (isPointOnArcRisk(x, y, centerX, centerY, innerRadius, closedAngle + doneAngle, closedAngle + doneAngle + todoAngle, strokeWidth)) {
      tooltipText = `${i18n('titleNbTodo').charAt(0).toUpperCase() + i18n('titleNbTodo').slice(1)} : ${todo}`;
    }
    positionTooltip(e, tooltipText);
  });
  
  // Mouse leave handler
  canvas.addEventListener('mouseleave', () => {
    tooltip.style.opacity = '0';
  });
  canvas.tooltipSetup = true;
}
        
// Function to check whether a point lies on an arc for risks (full circle)
function isPointOnArcRisk(x, y, centerX, centerY, radius, startAngle, endAngle, strokeWidth) {
  const dx = x - centerX;
  const dy = y - centerY;
  const distance = Math.sqrt(dx * dx + dy * dy);
  const angle = Math.atan2(dy, dx);        
  let normalizedAngle = angle;
  if (normalizedAngle < 0) normalizedAngle += 2 * Math.PI;         
  const isInRadius = distance >= radius - strokeWidth / 2 && distance <= radius + strokeWidth / 2;
  const isInAngle = normalizedAngle >= startAngle && normalizedAngle <= endAngle;   
  return isInRadius && isInAngle;
}
        
function adjustChartSizes(tileElement) {
  const container = tileElement.querySelector('.tile-progress-charts');
  if (!container) return;
  
  const allChartDivs = container.querySelectorAll('.tile-work-progress, .tile-budget-progress, .tile-risks-progress');
  let visibleCount = 0;
  allChartDivs.forEach(function(div) {
    var style = window.getComputedStyle(div);
    if (style.display !== 'none') {
      visibleCount++;
    }
  });
  container.classList.remove('charts-count-1', 'charts-count-2', 'charts-count-3');
  container.classList.add('charts-count-' + visibleCount);

  const tileWidth = tileElement.clientWidth;
  const gap = 5;

  let size;
  if (visibleCount === 0) {
    return;
  } else if (visibleCount === 1) {
    size = Math.min(150, tileWidth * 0.5);
  } else if (visibleCount === 2) {
    size = Math.min(150, (tileWidth - gap) / 2);
  } else {
    size = Math.min(150, (tileWidth - gap) / 3);
  }
  
  size = Math.max(100, size);
  
  const canvases = container.querySelectorAll('canvas'); 
  canvases.forEach(function(canvas) {
    if (canvas.parentElement.style.display !== 'none') {
      canvas.width = size;
      canvas.height = size;
    }
  });
}

function redrawChartsForTile(tileElement) {
  var projectId = tileElement.getAttribute('data-project-id');
  if (!projectId) return;
  var project = null;
  var projectList = dbd.getProjectList();
  for (var i = 0; i < projectList.length; i++) {
    if (projectList[i].getId() == projectId) {
      project = projectList[i];
      break;
    }
  }
  if (!project) return;
  var workProgressCanvas = document.getElementById('workProgress-' + projectId);
  if (workProgressCanvas && workProgressCanvas.offsetParent !== null) {
    progressChart(workProgressCanvas, project.getWorkValidated(), project.getWorkReal(), project.getWorkLeft(), project.getWorkPlanned(),'workProgressCanvas','<div class="iconImputation16 imageColorNewGui iconImputation iconSize16"></div>');
  }
  
  var budgetProgressCanvas = document.getElementById('budgetProgress-' + projectId);
  if (budgetProgressCanvas && budgetProgressCanvas.offsetParent !== null) {
    progressChart(budgetProgressCanvas, project.getTotalValidatedCost(), project.getTotalRealCost(), project.getTotalLeftCost(), project.getTotalPlannedCost(),'budgetProgressCanvas','<div class="iconExpenses16 imageColorNewGui iconExpenses iconSize16"></div>');
  }
  
  var risksProgressCanvas = document.getElementById('risksProgress-' + projectId);
  if (risksProgressCanvas && risksProgressCanvas.offsetParent !== null) {
    progressChartRisk(risksProgressCanvas, project.getClosedRisk(), project.getDoneRisk(), project.getTodoRisk(), project.getTotalRisk(),'<div class="iconCriticality16 imageColorNewGui iconCriticality iconSize16"></div>');
  }
}

function setupTooltipDashboard(element, getContentCallback) {
  if (element.tooltipSetup) return;
  let tooltip = document.getElementById('tooltip_projectDash');
  if (!tooltip) {
    tooltip = document.createElement('div');
    tooltip.id = 'tooltip_projectDash';
    tooltip.style.cssText = `
      position: fixed;
      background-color: rgba(0, 0, 0, 0.8);
      color: white;
      padding: 8px 12px;
      border-radius: 4px;
      font-size: 14px;
      pointer-events: none;
      z-index: 10000;
      opacity: 0;
      transition: opacity 0.2s;
      white-space: normal;
      max-width: 300px;
    `;
    document.body.appendChild(tooltip);
  }

  // Function to position tooltip
  function positionTooltip(e, content) {
    if (typeof content === 'string') {
      tooltip.textContent = content;
    } else {
      tooltip.innerHTML = content;
    }
    // Get tooltip dimensions
    const tooltipRect = tooltip.getBoundingClientRect();
    const tooltipWidth = tooltipRect.width;
    const tooltipHeight = tooltipRect.height;
    // Get viewport dimensions
    const viewportWidth = window.innerWidth;
    const viewportHeight = window.innerHeight;
    // Default position (right and above cursor)
    let left = e.clientX + 10;
    let top = e.clientY - 30;
    // Check if tooltip goes beyond right edge
    if (left + tooltipWidth > viewportWidth) {
      left = e.clientX - tooltipWidth - 10; // Position to the left of cursor
    }
    // Check if tooltip goes beyond left edge
    if (left < 0) {
      left = 10; // Minimum margin from left
    }
    // Check if tooltip goes beyond top edge
    if (top < 0) {
      top = e.clientY + 20; // Position below cursor instead
    }
    // Check if tooltip goes beyond bottom edge
    if (top + tooltipHeight > viewportHeight) {
      top = viewportHeight - tooltipHeight - 10; // Position at bottom with margin
    }

    tooltip.style.left = left + 'px';
    tooltip.style.top = top + 'px';
  }

  // Mouse enter handler
  element.addEventListener('mouseenter', (e) => {
    const content = getContentCallback();
    if (content) {
      tooltip.style.opacity = '1';
      positionTooltip(e, content);
    }
  });

  // Mouse move handler
  element.addEventListener('mousemove', (e) => {
    const content = getContentCallback();
    if (content) {
      positionTooltip(e, content);
    }
  });

  // Mouse leave handler
  element.addEventListener('mouseleave', () => {
    tooltip.style.opacity = '0';
  });

  element.tooltipSetup = true;
}

function setupTooltipNoData(canvas, chartType) {
  if (canvas.tooltipSetup) return;
  
  let tooltip = document.getElementById('tooltip_projectDash');
  if (!tooltip) {
    tooltip = document.createElement('div');
    tooltip.id = 'tooltip_projectDash';
    tooltip.style.cssText = `
      position: fixed;
      background-color: rgba(0, 0, 0, 0.8);
      color: white;
      padding: 8px 12px;
      border-radius: 4px;
      font-size: 14px;
      pointer-events: none;
      z-index: 10000;
      opacity: 0;
      transition: opacity 0.2s;
      white-space: nowrap;
    `;
    document.body.appendChild(tooltip);
  }
  
  function positionTooltip(e, tooltipText) {
    if (!tooltipText) {
      tooltip.style.opacity = '0';
      return;
    }
    tooltip.textContent = tooltipText;
    tooltip.style.opacity = '1';
    tooltip.style.left = '-9999px';
    tooltip.style.top = '-9999px';
    tooltip.style.opacity = '1';
    const tooltipRect = tooltip.getBoundingClientRect();
    const tooltipWidth = tooltipRect.width;
    const tooltipHeight = tooltipRect.height;
    const viewportWidth = window.innerWidth;
    const viewportHeight = window.innerHeight;
    let left = e.clientX + 10;
    let top = e.clientY - 30;
    if (left + tooltipWidth > viewportWidth) left = e.clientX - tooltipWidth - 10;
    if (left < 0) left = 10;
    if (top < 0) top = e.clientY + 20;
    if (top + tooltipHeight > viewportHeight) top = viewportHeight - tooltipHeight - 10;
    tooltip.style.left = left + 'px';
    tooltip.style.top = top + 'px';
  }
  
  canvas.addEventListener('mousemove', (e) => {
    let tooltipText = '';
    
    if (chartType === 'workProgressCanvas') {
      tooltipText = `${i18n('noDataFound')} - ${i18n('sectionWork')}`;
    } else if (chartType === 'budgetProgressCanvas') {
      tooltipText = `${i18n('noDataFound')} - ${i18n('Budget')}`;
    } else if (chartType === 'risksProgressCanvas') {
      tooltipText = `${i18n('noDataFound')} - ${i18n('menuRiskManagement')}`;
    }
    
    positionTooltip(e, tooltipText);
  });
  
  canvas.addEventListener('mouseleave', () => {
    tooltip.style.opacity = '0';
  });
  
  canvas.tooltipSetup = true;
}